/**
  ******************************************************************************
  * @file    init_bl.c 
  * @author  Ruediger R. Asche
  * @version V1.0.0
  * @date    14-July-2016
  * @brief   Minimum system initialization so the bootloader can start up
  ******************************************************************************
  * @attention
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, THE AUTHOR SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  ******************************************************************************  
  */ 

#include "stm32f4_discovery.h"

#define LED_ORANGE LED3
#define LED_GREEN  LED4
#define LED_BLUE   LED6
#define LED_RED    LED5

/** @brief Initializes the hardware. 
 *  In real life, this must include setting up the host communication interface
 *
 *  @return none
 */

void BoardInit(void)
{
    STM_EVAL_LEDInit(LED_ORANGE);
    STM_EVAL_LEDInit(LED_BLUE);
    STM_EVAL_LEDInit(LED_GREEN);
    STM_EVAL_LEDInit(LED_RED);
}



